// $Id: CXMLNode.cpp,v 1.4 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CXMLNode.hpp"
using Exponent::IO::CXMLNode;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CXMLNode, CCountedObject);

//	===========================================================================
CXMLNode::CXMLNode(const CString &name, CXMLNode *parent) : m_name(name), m_parentNode(parent)
{
	EXPONENT_CLASS_CONSTRUCTION(CXMLNode);

	// If we have a parent remember it
	if (m_parentNode)
	{
		m_parentNode->referenced();
	}
}

//	===========================================================================
CXMLNode::~CXMLNode()
{
	EXPONENT_CLASS_DESTRUCTION(CXMLNode);
	FORGET_COUNTED_OBJECT(m_parentNode);
}

//	===========================================================================
void CXMLNode::setParentNode(CXMLNode *parent)
{
	EXCHANGE_COUNTED_OBJECTS(m_parentNode, parent);
}

//	===========================================================================
CXMLNode *CXMLNode::getParentNode()
{
	return m_parentNode;
}

//	===========================================================================
void CXMLNode::setNodeName(const CString &name)
{
	m_name = name;
}

//	===========================================================================
const CString &CXMLNode::getNodeName() const
{
	return m_name;
}

//	===========================================================================
void CXMLNode::addAttribute(const CString &name, const CString &value)
{
	this->addAttribute(new CXMLAttribute(name, value));
}

//	===========================================================================
void CXMLNode::addAttribute(CXMLAttribute *attribute)
{
	// Check its valid
	if (attribute)
	{
		// Add the element
		m_attributes.addElement(attribute);
		m_attributes.reorder();
	}
}

//	===========================================================================
long CXMLNode::getNumberOfAttributes() const
{
	return m_attributes.getInsertIndex();
}

//	===========================================================================
CXMLAttribute *CXMLNode::getAttribute(const long index)
{
	return m_attributes.elementAtIndex(index);
}

//	===========================================================================
CXMLAttribute *CXMLNode::getAttribute(const CString &name)
{
	for (long i = 0; i < m_attributes.getInsertIndex(); i++)
	{
		// Get the attribute
		CXMLAttribute *attribute = m_attributes.elementAtIndex(i);

		// Check if its the one
		if (attribute && attribute->getName() == name)
		{
			return attribute;
		}
	}

	// Failed!
	return NULL;
}

//	===========================================================================
const CXMLAttribute *CXMLNode::getConstAttribute(const long index) const 
{
	return m_attributes.constElementAtIndex(index);
}

//	===========================================================================
const CXMLAttribute *CXMLNode::getConstAttribute(const CString &name) const
{
	for (long i = 0; i < m_attributes.getInsertIndex(); i++)
	{
		// Get the attribute
		const CXMLAttribute *attribute = m_attributes.constElementAtIndex(i);

		// Check if its the one
		if (attribute && attribute->getName() == name)
		{
			return attribute;
		}
	}

	// Failed!
	return NULL;
}

//	===========================================================================
CString CXMLNode::getValueOfAttributeNamed(const CString &name)
{
	// Get the attribute
	CXMLAttribute *attribute = this->getAttribute(name);

	// Check if its valid
	if (attribute == NULL)
	{
		return CString::emptyString();
	}

	// Return the value
	return attribute->getValue();
}

//	===========================================================================
void CXMLNode::removeAttribute(CXMLAttribute *attribute)
{
	if (attribute)
	{
		m_attributes.deletePointerAtIndex(m_attributes.getIndexOfPointer(attribute));
		m_attributes.reorder(true);
	}
}

//	===========================================================================
void CXMLNode::removeAttribute(const CString &name)
{
	this->removeAttribute(this->getAttribute(name));
}

//	===========================================================================
void CXMLNode::clearAttributes()
{
	m_attributes.clearArray();
}

//	===========================================================================
void CXMLNode::addChildNode(CXMLNode *node)
{
	if (node)
	{
		// We are the parent
		node->setParentNode(this);

		// Add the node
		m_children.addElement(node);
		m_children.reorder();
	}
}

//	===========================================================================
void CXMLNode::addChildNode(const CString &name)
{
	this->addChildNode(new CXMLNode(name, this));
}

//	===========================================================================
long CXMLNode::getNumberOfChildNodes() const
{
	return m_children.getInsertIndex();
}

//	===========================================================================
const CXMLNode *CXMLNode::getConstChildNode(const long index) const
{
	return m_children.constElementAtIndex(index);
}

//	===========================================================================
const CXMLNode *CXMLNode::getConstChildNode(const CString &name) const
{
	for (long i = 0; i < m_children.getInsertIndex(); i++)
	{
		// Get the attribute
		const CXMLNode *node = m_children.constElementAtIndex(i);

		// Check if its the one
		if (node && node->getNodeName() == name)
		{
			return node;
		}
	}

	// Failed!
	return NULL;
}

//	===========================================================================
const CXMLNode *CXMLNode::getConstFirstChildNode(const CString &name) const
{
	for (long i = 0; i < m_children.getInsertIndex(); i++)
	{
		// Get the attribute
		const CXMLNode *node = m_children.constElementAtIndex(i);

		// Check if its the one
		if (node == NULL)
		{
			continue;
		}

		// Check if this is the child
		if (node->getNodeName() == name)
		{
			return node;
		}

		// Get the child node
		const CXMLNode *child = node->getConstFirstChildNode(name);

		// Check if its valid
		if (child == NULL)
		{
			continue;
		}

		// Make sure name is right
		if (child->getNodeName() == name)
		{
			return child;
		}
	}

	// Failed!
	return NULL;
}

//	===========================================================================
CXMLNode *CXMLNode::getChildNode(const long index)
{
	return m_children.elementAtIndex(index);
}

//	===========================================================================
CXMLNode *CXMLNode::getChildNode(const CString &name)
{
	for (long i = 0; i < m_children.getInsertIndex(); i++)
	{
		// Get the attribute
		CXMLNode *node = m_children.elementAtIndex(i);

		// Check if its the one
		if (node && node->getNodeName() == name)
		{
			return node;
		}
	}

	// Failed!
	return NULL;
}

//	===========================================================================
CXMLNode *CXMLNode::getFirstChildNode(const CString &name)
{
	for (long i = 0; i < m_children.getInsertIndex(); i++)
	{
		// Get the attribute
		CXMLNode *node = m_children.elementAtIndex(i);

		// Check if its the one
		if (node == NULL)
		{
			continue;
		}

		// Check if this is the child
		if (node->getNodeName() == name)
		{
			return node;
		}

		// Get the child node
		CXMLNode *child = node->getFirstChildNode(name);

		// Check if its valid
		if (child == NULL)
		{
			continue;
		}

		// Make sure name is right
		if (child->getNodeName() == name)
		{
			return child;
		}
	}

	// Failed!
	return NULL;
}

//	===========================================================================
void CXMLNode::removeChildNode(CXMLNode *node)
{
	if (node)
	{
		m_children.deletePointerAtIndex(m_children.getIndexOfPointer(node));
		m_children.reorder(true);
	}
}

//	===========================================================================
void CXMLNode::removeChildNode(const CString &name)
{
	this->removeChildNode(this->getChildNode(name));
}

//	===========================================================================
void CXMLNode::clearChildNodes()
{
	m_children.clearArray();
}